<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

$upload = Downloads::load_module('upload');

$uploads = vB_Template::create('dbtech_downloads_upload');

($hook = vBulletinHook::fetch_hook('dbtech_downloads_upload_start')) ? eval($hook) : false;

$catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_INT);

$permissions = unserialize($vbulletin->dbtech_downloads_categories[$catid]['permissions']);
$secondary		= explode(',', $vbulletin->userinfo['membergroupids']);

$canview = false;
foreach ($secondary AS $ugid) {
	if (in_array($ugid, (array)$permissions['upload'])) {
		$canview = true;
	}
}

if ($canview == true || in_array($vbulletin->userinfo['usergroupid'], (array)$permissions['upload'])) {
	$canview = true;
}

if (!$canview && $catid > 0) { // $catid = 0 allows for inital choice for uploading
	print_no_permission();
}

$category_getall = $db->query_read("
	SELECT * FROM  " . TABLE_PREFIX . "dbtech_downloads_categories
	ORDER BY catname ASC
");

$categories = '';
while ($cat = $db->fetch_array($category_getall)) {
	if ($cat['catid'] == $catid) {
		$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?do=listings&catid=' . $cat['catid']] = $cat['catname'];
		
		if ($cat['private'] == 1) {
			$display['users'] 		= 1;
		}
		
		if ($cat['password'] == 1) {
			$display['password'] 	= 1;
		}
		
		$extgroups = $cat['extgroupids'];
		
		$categories .= '<option value="' . $cat['catid'] . '" selected="selected">' . $cat['catname'] . '</option>' . "\n";
	} else {
		$categories .= '<option value="' . $cat['catid'] . '">' . $cat['catname'] . '</option>' . "\n";
	}
}

if (!empty($extgroups)) {
	$getexts = $db->query("
		SELECT extgroup.*, ext.* FROM " . TABLE_PREFIX . "dbtech_downloads_extension_groups AS extgroup
		LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_extensions AS ext ON (extgroup.extgroupid = ext.extgroupid)
		WHERE extgroup.extgroupid IN ($extgroups)
	");
	
	$allowedexts = array();
	while ($ext = $db->fetch_array($getexts)) {
		$allowedexts[$ext['extension']] = $ext['maxsize'];
	}
}

$extensioninfo = '';

foreach ((array)$allowedexts AS $extension => $maxsize) {
	$exttemp = vB_Template::create('dbtech_downloads_upload_extinfo');
	
	$exttemp->register('extension', $extension);
	$exttemp->register('maxsize', Downloads::convert_filesize($maxsize));
	
	$extensioninfo .= $exttemp->render();
	
	//$extensioninfo .= construct_phrase($vbphrase['dbtech_downloads_extension_info'], $extension, Downloads::convert_filesize($maxsize));
}

$navbits[] = $vbphrase['dbtech_downloads_upload'];

require_once(DIR . '/includes/functions_editor.php');

// Set $vbulletin->options['allowbbimagecode'] to true for display of img button.
$imgbbcodeval 									= $vbulletin->options['allowbbimagecode'];
$vbulletin->options['allowbbimagecode'] 		= true;

$editorid = construct_edit_toolbar(" ", false , 'nonforum', true, true, false, 'fe');  

// Reset $vbulletin->options['allowbbimagecode'] value to original.
$vbulletin->options['allowbbimagecode'] = $imgbbcodeval;

$fileinputs = '';

for ($i=2; $i<$vbulletin->options['dbtech_downloads_max_downloads'] + 1; $i++) {
	$fileinputs .= '<input type="file" name="upload[]" style="display: none;" id="fileinput_' . $i . '" />' . "\n";
}

($hook = vBulletinHook::fetch_hook('dbtech_downloads_upload_complete')) ? eval($hook) : false;

$uploads->register('category', $category['catname']);
$uploads->register('catid', $category['catid']);
$uploads->register('categories', $categories);
$uploads->register('editorid', $editorid); 
$uploads->register('display', $display);
$uploads->register('fileinputs', $fileinputs);
$uploads->register('extensioninfo', $extensioninfo);
$uploads->register('messagearea', $messagearea);
$uploads->register('template_hook', $template_hook);

$JAVASCRIPT_INCLUDE .= '
Downloads.init_upload_page();

var THIS_DOWNLOAD_PAGE = "adding";
var DO_MIRRORS = ' . $vbulletin->options['dbtech_downloads_mirrors_enabled'] . ';
var MAX_FILEINPUTS = ' . $vbulletin->options['dbtech_downloads_max_downloads'] . ';';

$HTML .= $uploads->render();

?>